create or replace procedure tbicds.PRC_UTL_TRUNCATE_PATIENT_DATA
AUTHID CURRENT_USER
is
   procedure updateConstraints (
      pi_vTable                         in varchar2,
      pi_vStatus                        in varchar2
      )
   is
      v_vSql                               varchar2(4000);
      rc                                   sys_refcursor;
      v_vTableName                         varchar2(30);
      v_vConstraintName                    varchar2(30);
   begin
      v_vSql := 'select t.table_name, t.constraint_name '
                || 'from user_constraints t '
                || 'where t.constraint_type = ''R'' '
                || 'and t.r_constraint_name in ('
                || 'select t1.constraint_name '
                || 'from user_constraints t1 '
                || 'where t1.owner like user '
                || 'and t1.constraint_type in (''P'', ''U'') '
                || 'and t1.table_name like :P0'
                || ') ';
      open rc for v_vSql using pi_vTable;
      loop
         fetch rc into v_vTableName, v_vConstraintName;
         exit when rc%notfound;

         execute immediate ('alter table '||v_vTableName||' '||pi_vStatus||' constraint '||v_vConstraintName);
      end loop;
   exception
      when others
      then
         null;
   end;

   procedure truncateTable (
      pi_vTableName                     in varchar2
      )
   is
      v_vSql                               varchar2(4000);
      rc                                   sys_refcursor;
      v_vTableName                         varchar2(30);
   begin
      v_vSql := 'select table_name from user_tables where table_name like :P0 order by table_name';
      open rc for v_vSql using trim(upper(pi_vTableName));
      loop
         fetch rc into v_vTableName;
         exit when rc%notfound;
         
         updateConstraints (v_vTableName, 'disable');
         execute immediate ('truncate table ' || v_vTableName);
         updateConstraints (v_vTableName, 'enable');
      end loop;
      close rc;
   end;

begin
   truncateTable ('PATIENT%');
   truncateTable ('PAT_%');
   truncateTable ('DATA_INTAKE%');
   truncateTable ('FX_AUDIT%');
   truncateTable ('FX_SESSION%');

   for i in 1..5
   loop
      truncateTable ('ENCOUNTER%');
      truncateTable ('TREATMENT%');
   end loop;   
      
end;
/

